/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.fields;

import filenet.vw.api.VWParameter;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.table.VWFieldDataForTable;

public class VWFieldValue {
    protected VWParameter m_vwParameter = null;
    protected VWFieldDataForTable m_fieldData = null;

    public VWFieldValue(VWParameter vwParameter) {
        try {
            this.m_vwParameter = vwParameter;
            this.m_fieldData = new VWFieldDataForTable(vwParameter.getFieldType(), vwParameter.isArray(), vwParameter.getValue(), vwParameter.getName(), vwParameter.getMode() == 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Object getValue() {
        return this.m_fieldData;
    }

    public void setValue(Object newValue) {
        try {
            if (!this.isEditable()) {
                return;
            }
            if (newValue instanceof VWFieldDataForTable) {
                this.m_fieldData = (VWFieldDataForTable)newValue;
                this.m_vwParameter.setValue(this.m_fieldData.getValue());
            } else {
                this.m_fieldData = new VWFieldDataForTable(this.m_vwParameter.getFieldType(), this.m_vwParameter.isArray(), newValue, this.m_vwParameter.getName());
                this.m_vwParameter.setValue(newValue);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isEditable() {
        switch (this.m_vwParameter.getMode()) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public VWParameter getParameter() {
        return this.m_vwParameter;
    }
}

